/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;

public class SkullCandleBlock
extends AbstractSkullCandleBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    protected static final VoxelShape PIGLIN_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    protected static final VoxelShape ONE_CANDLE = Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape TWO_CANDLE = Block.m_49796_((double)5.0, (double)8.0, (double)6.0, (double)11.0, (double)14.0, (double)9.0);
    protected static final VoxelShape THREE_CANDLE = Block.m_49796_((double)5.0, (double)8.0, (double)6.0, (double)10.0, (double)14.0, (double)11.0);
    protected static final VoxelShape FOUR_CANDLE = Block.m_49796_((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)14.0, (double)10.0);
    protected static final VoxelShape SKULL_WITH_ONE = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)ONE_CANDLE);
    protected static final VoxelShape SKULL_WITH_TWO = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)TWO_CANDLE);
    protected static final VoxelShape SKULL_WITH_THREE = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)THREE_CANDLE);
    protected static final VoxelShape SKULL_WITH_FOUR = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)FOUR_CANDLE);
    protected static final VoxelShape PIGLIN_SKULL_WITH_ONE = Shapes.m_83110_((VoxelShape)PIGLIN_SHAPE, (VoxelShape)ONE_CANDLE);
    protected static final VoxelShape PIGLIN_SKULL_WITH_TWO = Shapes.m_83110_((VoxelShape)PIGLIN_SHAPE, (VoxelShape)TWO_CANDLE);
    protected static final VoxelShape PIGLIN_SKULL_WITH_THREE = Shapes.m_83110_((VoxelShape)PIGLIN_SHAPE, (VoxelShape)THREE_CANDLE);
    protected static final VoxelShape PIGLIN_SKULL_WITH_FOUR = Shapes.m_83110_((VoxelShape)PIGLIN_SHAPE, (VoxelShape)FOUR_CANDLE);
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.m_137537_(() -> {
        Int2ObjectOpenHashMap var0 = new Int2ObjectOpenHashMap();
        var0.defaultReturnValue((Object)ImmutableList.of());
        var0.put(1, (Object)ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5)));
        var0.put(2, (Object)ImmutableList.of((Object)new Vec3(0.375, 0.94, 0.5), (Object)new Vec3(0.625, 1.0, 0.44)));
        var0.put(3, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.813, 0.625), (Object)new Vec3(0.375, 0.94, 0.5), (Object)new Vec3(0.56, 1.0, 0.44)));
        var0.put(4, (Object)ImmutableList.of((Object)new Vec3(0.44, 0.813, 0.56), (Object)new Vec3(0.625, 0.94, 0.56), (Object)new Vec3(0.375, 0.94, 0.375), (Object)new Vec3(0.56, 1.0, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)var0);
    });

    public SkullCandleBlock(SkullBlock.Type type, BlockBehaviour.Properties properties) {
        super(type, properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        int n;
        boolean piglin = this.getType() == SkullBlock.Types.PIGLIN;
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            n = sc.getCandleAmount();
        } else {
            n = 1;
        }
        return switch (n) {
            default -> {
                if (piglin) {
                    yield PIGLIN_SKULL_WITH_ONE;
                }
                yield SKULL_WITH_ONE;
            }
            case 2 -> {
                if (piglin) {
                    yield PIGLIN_SKULL_WITH_TWO;
                }
                yield SKULL_WITH_TWO;
            }
            case 3 -> {
                if (piglin) {
                    yield PIGLIN_SKULL_WITH_THREE;
                }
                yield SKULL_WITH_THREE;
            }
            case 4 -> piglin ? PIGLIN_SKULL_WITH_FOUR : SKULL_WITH_FOUR;
        };
    }

    @Override
    protected Iterable<Vec3> getParticleOffsets(BlockState state, LevelAccessor accessor, BlockPos pos) {
        int n;
        BlockEntity blockEntity = accessor.m_7702_(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            n = sc.getCandleAmount();
        } else {
            n = 1;
        }
        return (Iterable)PARTICLE_OFFSETS.get(n);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(Mth.m_14107_((double)((double)(ctx.m_7074_() * 16.0f / 360.0f) + 0.5)) & 0xF))).m_61124_((Property)LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rot.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirror.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ROTATION});
    }
}

