/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.block.patch;

import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import twilightforest.block.PatchBlock;
import twilightforest.init.TFBlocks;

public record PatchModel(ResourceLocation location, TextureAtlasSprite texture, boolean shaggify) implements BakedModel
{
    private static final FaceBakery BAKERY = new FaceBakery();
    private static final Vector3f MIN = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f MAX = new Vector3f(0.0f, 0.0f, 0.0f);

    private void setVectors(AABB bb) {
        MIN.set((float)bb.f_82288_, (float)bb.f_82289_, (float)bb.f_82290_);
        MAX.set((float)bb.f_82291_, (float)bb.f_82292_, (float)bb.f_82293_);
    }

    private void setVectors(AABB bb, boolean north, boolean east, boolean south, boolean west) {
        MIN.set(west ? 0.0f : (float)bb.f_82288_, (float)bb.f_82289_, north ? 0.0f : (float)bb.f_82290_);
        MAX.set(east ? 16.0f : (float)bb.f_82291_, (float)bb.f_82292_, south ? 16.0f : (float)bb.f_82293_);
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource random) {
        if (state == null) {
            return this.getQuads(false, false, false, false, PatchBlock.AABBFromRandom(random), random);
        }
        return this.getQuads((Boolean)state.m_61143_((Property)PatchBlock.NORTH), (Boolean)state.m_61143_((Property)PatchBlock.EAST), (Boolean)state.m_61143_((Property)PatchBlock.SOUTH), (Boolean)state.m_61143_((Property)PatchBlock.WEST), PatchBlock.AABBFromRandom(random), random);
    }

    private List<BakedQuad> getQuads(boolean north, boolean east, boolean south, boolean west, AABB bb, RandomSource random) {
        float originalMaxX;
        int num3;
        int num2;
        int num1;
        int num0;
        long seed;
        float originalMaxZ;
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        this.setVectors(bb, north, east, south, west);
        this.quadsFromAABB(list);
        if (!this.shaggify()) {
            return list;
        }
        this.setVectors(bb);
        if (MIN.x() > 0.0f) {
            originalMaxZ = MAX.z();
            seed = random.m_188505_();
            seed = seed * seed * 42317861L + seed * 7L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            PatchModel.MAX.x = MIN.x();
            MIN.add(-1.0f, 0.0f, (float)num0);
            if (MAX.z() - (float)(num1 + num2 + num3) > MIN.z()) {
                PatchModel.MAX.z = MIN.z() + (float)num1;
                this.quadsFromAABB(list);
                PatchModel.MAX.z = originalMaxZ - (float)num2;
                PatchModel.MIN.z = MAX.z() - (float)num3;
                this.quadsFromAABB(list);
            } else {
                MAX.add(0.0f, 0.0f, (float)(-num2));
                this.quadsFromAABB(list);
            }
            this.setVectors(bb);
        }
        if (MAX.x() < 16.0f) {
            originalMaxZ = MAX.z();
            seed = random.m_188505_();
            seed = seed * seed * 42317861L + seed * 17L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            PatchModel.MIN.x = MAX.x();
            MAX.add(1.0f, 0.0f, 0.0f);
            MIN.add(0.0f, 0.0f, (float)num0);
            if (MAX.z() - (float)(num1 + num2 + num3) > MIN.z()) {
                PatchModel.MAX.z = MIN.z() + (float)num1;
                this.quadsFromAABB(list);
                PatchModel.MAX.z = originalMaxZ - (float)num2;
                PatchModel.MIN.z = MAX.z() - (float)num3;
                this.quadsFromAABB(list);
            } else {
                MAX.add(0.0f, 0.0f, (float)(-num2));
                this.quadsFromAABB(list);
            }
            this.setVectors(bb);
        }
        if (MIN.z() > 0.0f) {
            originalMaxX = MAX.x();
            seed = random.m_188505_();
            seed = seed * seed * 42317861L + seed * 23L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            PatchModel.MAX.z = MIN.z();
            MIN.add((float)num0, 0.0f, -1.0f);
            PatchModel.MAX.x = MIN.x() + (float)num1;
            this.quadsFromAABB(list);
            PatchModel.MAX.x = originalMaxX - (float)num2;
            PatchModel.MIN.x = MAX.x() - (float)num3;
            this.quadsFromAABB(list);
            this.setVectors(bb);
        }
        if (MAX.z() < 16.0f) {
            originalMaxX = MAX.x();
            seed = random.m_188505_();
            seed = seed * seed * 42317861L + seed * 11L;
            num0 = (int)(seed >> 12 & 3L) + 1;
            num1 = (int)(seed >> 15 & 3L) + 1;
            num2 = (int)(seed >> 18 & 3L) + 1;
            num3 = (int)(seed >> 21 & 3L) + 1;
            PatchModel.MIN.z = MAX.z();
            MAX.add(0.0f, 0.0f, 1.0f);
            MIN.add((float)num0, 0.0f, 0.0f);
            PatchModel.MAX.x = MIN.x() + (float)num1;
            this.quadsFromAABB(list);
            PatchModel.MAX.x = originalMaxX - (float)num2;
            PatchModel.MIN.x = MAX.x() - (float)num3;
            this.quadsFromAABB(list);
            this.setVectors(bb);
        }
        return list;
    }

    private void quadsFromAABB(List<BakedQuad> quads) {
        quads.add(this.quadFromVectors(MIN, MAX, Direction.UP));
        quads.add(this.quadFromVectors(MIN, MAX, Direction.NORTH));
        quads.add(this.quadFromVectors(MIN, MAX, Direction.EAST));
        quads.add(this.quadFromVectors(MIN, MAX, Direction.SOUTH));
        quads.add(this.quadFromVectors(MIN, MAX, Direction.WEST));
    }

    private BakedQuad quadFromVectors(Vector3f min, Vector3f max, Direction direction) {
        String string = this.texture().m_247685_().toString();
        BlockElementFace face = new BlockElementFace(null, 0, string, switch (direction) {
            case Direction.NORTH -> new BlockFaceUV(new float[]{max.x(), min.z() + 1.0f, min.x(), min.z()}, 0);
            case Direction.EAST -> new BlockFaceUV(new float[]{max.x(), min.z(), max.x() - 1.0f, max.z()}, 90);
            case Direction.SOUTH -> new BlockFaceUV(new float[]{min.x(), max.z(), max.x(), max.z() - 1.0f}, 0);
            case Direction.WEST -> new BlockFaceUV(new float[]{min.x(), max.z(), min.x() + 1.0f, min.z()}, 90);
            default -> new BlockFaceUV(new float[]{min.x(), min.z(), max.x(), max.z()}, 0);
        });
        return BAKERY.m_111600_(min, max, face, this.texture(), direction, (ModelState)new SimpleModelState(Transformation.m_121093_()), null, true, this.location);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.texture;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (state.m_60713_((Block)TFBlocks.CLOVER_PATCH.get())) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
        }
        return super.getRenderTypes(state, rand, data);
    }
}

