/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.ai.control.NoClipMoveControl;
import twilightforest.entity.ai.goal.SimplifiedAttackGoal;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;

public class Wraith
extends FlyingMob
implements Enemy,
EnforcedHomePoint {
    private static final EntityDataAccessor<Optional<GlobalPos>> HOME_POINT = SynchedEntityData.m_135353_(Wraith.class, (EntityDataSerializer)EntityDataSerializers.f_238113_);

    public Wraith(EntityType<? extends Wraith> type, Level level) {
        super(type, level);
        this.f_21342_ = new NoClipMoveControl((Mob)this);
        this.f_19794_ = true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsHomeGoal(this, 0.85));
        this.f_21345_.m_25352_(4, (Goal)new SimplifiedAttackGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FlyTowardsTargetGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new RandomFloatAroundGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 5.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(HOME_POINT, Optional.empty());
    }

    public boolean m_20161_() {
        return true;
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            Entity entity = source.m_7639_();
            if (this.m_20202_() == entity || this.m_20197_().contains(entity)) {
                return true;
            }
            if (entity != this && entity instanceof LivingEntity && !source.m_19390_()) {
                this.m_6710_((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    public boolean m_7327_(Entity entity) {
        entity.m_6469_(TFDamageTypes.getEntityDamageSource(this.m_9236_(), TFDamageTypes.HAUNT, (Entity)this, new EntityType[0]), (float)this.m_21133_(Attributes.f_22281_));
        return super.m_7327_(entity);
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.WRAITH_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.WRAITH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.WRAITH_DEATH.get();
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends Wraith> entity, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Wraith.m_217057_(entity, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (type == MobSpawnType.STRUCTURE || type == MobSpawnType.SPAWNER) {
            this.m_21446_(this.m_20183_(), 20);
        }
        return super.m_6518_(accessor, difficulty, type, data, tag);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.saveHomePointToNbt(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.loadHomePointFromNbt(tag);
    }

    @Override
    @Nullable
    public GlobalPos getRestrictionPoint() {
        return ((Optional)this.m_20088_().m_135370_(HOME_POINT)).orElse(null);
    }

    @Override
    public void setRestrictionPoint(@Nullable GlobalPos pos) {
        this.m_20088_().m_135381_(HOME_POINT, Optional.ofNullable(pos));
    }

    @Override
    public int getHomeRadius() {
        return 20;
    }

    public static class MoveTowardsHomeGoal
    extends Goal {
        private final Wraith mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;

        public MoveTowardsHomeGoal(Wraith mob, double speedModifier) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.isMobWithinHomeArea((Entity)this.mob) || this.mob.m_5448_() != null) {
                return false;
            }
            BlockPos pos = this.mob.getRestrictionPoint().m_122646_().m_121945_(Direction.m_235672_((RandomSource)this.mob.m_217043_())).m_7918_(this.mob.m_217043_().m_188503_(5), this.mob.m_217043_().m_188503_(5), this.mob.m_217043_().m_188503_(5));
            if (!this.mob.m_9236_().m_46749_(pos)) {
                return false;
            }
            this.wantedX = pos.m_123341_();
            this.wantedY = pos.m_123342_();
            this.wantedZ = pos.m_123343_();
            return true;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.mob.m_21566_().m_6849_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }
    }

    static class FlyTowardsTargetGoal
    extends Goal {
        private final Wraith wraith;

        FlyTowardsTargetGoal(Wraith wraith) {
            this.wraith = wraith;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.wraith.m_5448_() != null;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            LivingEntity target = this.wraith.m_5448_();
            if (target != null) {
                this.wraith.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 0.5);
            }
        }
    }

    static class RandomFloatAroundGoal
    extends Goal {
        private final Wraith wraith;

        public RandomFloatAroundGoal(Wraith wraith) {
            this.wraith = wraith;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            if (this.wraith.m_5448_() != null || !this.wraith.isMobWithinHomeArea((Entity)this.wraith)) {
                return false;
            }
            MoveControl control = this.wraith.m_21566_();
            double d0 = control.m_25000_() - this.wraith.m_20185_();
            double d3 = d0 * d0 + (d1 = control.m_25001_() - this.wraith.m_20186_()) * d1 + (d2 = control.m_25002_() - this.wraith.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.wraith.m_217043_();
            double d0 = this.wraith.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.wraith.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.wraith.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.wraith.m_21566_().m_6849_(d0, d1, d2, 0.5);
        }
    }

    public static class LookAroundGoal
    extends Goal {
        private final Wraith wraith;

        public LookAroundGoal(Wraith wraith) {
            this.wraith = wraith;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.wraith.m_5448_() == null) {
                this.wraith.m_146922_(-((float)Mth.m_14136_((double)this.wraith.m_20184_().m_7096_(), (double)this.wraith.m_20184_().m_7094_())) * 57.295776f);
                this.wraith.m_5618_(this.wraith.m_146908_());
            } else {
                LivingEntity entitylivingbase = this.wraith.m_5448_();
                if (entitylivingbase.m_20280_((Entity)this.wraith) < 4096.0) {
                    double d1 = entitylivingbase.m_20185_() - this.wraith.m_20185_();
                    double d2 = entitylivingbase.m_20189_() - this.wraith.m_20189_();
                    this.wraith.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.wraith.m_5618_(this.wraith.m_146908_());
                }
            }
        }
    }
}

