/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.GiantBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.init.TFBlocks;
import twilightforest.item.GiantItem;

public class GiantPickItem
extends PickaxeItem
implements GiantItem {
    public GiantPickItem(Tier material, Item.Properties properties) {
        super(material, 8, -3.5f, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, level, tooltip, flags);
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc")).m_130940_(ChatFormatting.GRAY));
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        ImmutableMultimap.Builder attributeBuilder = ImmutableMultimap.builder();
        attributeBuilder.putAll(super.m_7167_(slot));
        attributeBuilder.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(GIANT_REACH_MODIFIER, "Reach modifier", 2.5, AttributeModifier.Operation.ADDITION));
        attributeBuilder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(GIANT_RANGE_MODIFIER, "Range modifier", 2.5, AttributeModifier.Operation.ADDITION));
        return slot == EquipmentSlot.MAINHAND ? attributeBuilder.build() : super.m_7167_(slot);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        float destroySpeed = super.m_8102_(stack, state);
        return state.m_60734_() instanceof GiantBlock ? destroySpeed * 64.0f : (destroySpeed *= state.m_60734_() == TFBlocks.GIANT_OBSIDIAN.get() ? 64.0f : 1.0f);
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        ItemStack stack = pPlayer.m_21205_();
        if (stack.m_150930_((Item)this)) {
            pPlayer.getCapability(CapabilityList.GIANT_PICK_MINE).ifPresent(cap -> cap.setMining(pLevel.m_46467_()));
        }
        return super.m_6777_(pState, pLevel, pPos, pPlayer);
    }
}

