/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFPortalBlock;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFBlocks;
import twilightforest.item.MagicMapItem;
import twilightforest.util.LandmarkUtil;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.registration.TFGenerationSettings;

public class TFTeleporter
implements ITeleporter {
    private static final Map<ResourceLocation, Map<ColumnPos, PortalPosition>> destinationCoordinateCache = new HashMap<ResourceLocation, Map<ColumnPos, PortalPosition>>();
    private static boolean locked;

    public TFTeleporter(boolean locked) {
        TFTeleporter.locked = locked;
    }

    public static CompoundTag saveLinks() {
        CompoundTag tag = new CompoundTag();
        ListTag dcc = new ListTag();
        destinationCoordinateCache.forEach((rl, map) -> {
            CompoundTag ct = new CompoundTag();
            ListTag links = new ListTag();
            map.forEach((columnPos, portalPos) -> {
                CompoundTag link = new CompoundTag();
                CompoundTag column = new CompoundTag();
                column.m_128405_("x", columnPos.f_140723_());
                column.m_128405_("z", columnPos.f_140724_());
                link.m_128365_("column", (Tag)column);
                CompoundTag portal = new CompoundTag();
                portal.m_128356_("time", portalPos.lastUpdateTime);
                portal.m_128356_("pos", portalPos.pos.m_121878_());
                link.m_128365_("portal", (Tag)portal);
                links.add((Object)link);
            });
            ct.m_128365_("links", (Tag)links);
            ct.m_128359_("name", rl.toString());
            dcc.add((Object)ct);
        });
        tag.m_128365_("dest", (Tag)dcc);
        return tag;
    }

    public static void loadLinks(CompoundTag tag) {
        tag.m_128437_("dest", 10).stream().map(CompoundTag.class::cast).forEach(dest -> {
            ResourceLocation name = new ResourceLocation(dest.m_128461_("name"));
            destinationCoordinateCache.putIfAbsent(name, Maps.newHashMapWithExpectedSize((int)4096));
            dest.m_128437_("links", 10).stream().map(CompoundTag.class::cast).forEach(link -> {
                CompoundTag column = link.m_128469_("column");
                CompoundTag portal = link.m_128469_("portal");
                destinationCoordinateCache.get(name).put(new ColumnPos(column.m_128451_("x"), column.m_128451_("z")), new PortalPosition(BlockPos.m_122022_((long)portal.m_128454_("pos")), portal.m_128454_("time")));
            });
        });
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel dest, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        ServerLevel tfDim = dest.m_7654_().m_129880_(TFGenerationSettings.DIMENSION_KEY);
        double scale = tfDim == null ? 0.125 : tfDim.m_6042_().f_63859_();
        scale = dest.m_46472_().equals(TFGenerationSettings.DIMENSION_KEY) ? 1.0 / scale : scale;
        BlockPos destPos = dest.m_6857_().m_187569_((double)entity.m_20183_().m_123341_() * scale, (double)entity.m_20183_().m_123342_(), (double)entity.m_20183_().m_123343_() * scale);
        PortalInfo pos = TFTeleporter.placeInExistingPortal(dest, entity, destPos);
        if (pos == null) {
            TwilightForestMod.LOGGER.debug("Did not find existing portal, making a new one.");
            pos = TFTeleporter.moveToSafeCoords(dest, entity, destPos);
            this.makePortal(entity, dest, pos.f_77676_);
            pos = TFTeleporter.placeInExistingPortal(dest, entity, BlockPos.m_274446_((Position)pos.f_77676_));
        }
        return pos == null ? super.getPortalInfo(entity, dest, defaultPortalInfo) : pos;
    }

    @Nullable
    private static PortalInfo placeInExistingPortal(ServerLevel destDim, Entity entity, BlockPos pos) {
        BlockPos blockpos;
        PortalPosition portalPosition;
        boolean flag = true;
        ColumnPos columnPos = new ColumnPos(entity.m_20183_().m_123341_(), entity.m_20183_().m_123343_());
        PortalPosition portalPosition2 = portalPosition = destinationCoordinateCache.containsKey(destDim.m_46472_().m_135782_()) ? destinationCoordinateCache.get(destDim.m_46472_().m_135782_()).get(columnPos) : null;
        if (portalPosition != null) {
            blockpos = portalPosition.pos;
            portalPosition.lastUpdateTime = destDim.m_46467_();
            flag = false;
            TwilightForestMod.LOGGER.debug("Using cache, validating. {}", (Object)blockpos);
            if (blockpos == null || !destDim.m_8055_(blockpos).m_60713_((Block)TFBlocks.TWILIGHT_PORTAL.get())) {
                TwilightForestMod.LOGGER.debug("Portal Invalid, recreating.");
                blockpos = null;
                destinationCoordinateCache.get(destDim.m_46472_().m_135782_()).remove(columnPos);
            }
        } else {
            blockpos = TFTeleporter.getPortalPosition(destDim, pos);
        }
        if (blockpos == null) {
            return null;
        }
        if (flag) {
            TwilightForestMod.LOGGER.debug("Caching Src Portal Blocks to {}", (Object)blockpos);
            destinationCoordinateCache.putIfAbsent(destDim.m_46472_().m_135782_(), Maps.newHashMapWithExpectedSize((int)4096));
            HashMap<BlockPos, Boolean> portalBlocks = new HashMap<BlockPos, Boolean>();
            portalBlocks.put(entity.m_20183_(), true);
            TFPortalBlock.recursivelyValidatePortal(entity.m_9236_(), entity.m_20183_(), portalBlocks, new MutableInt(0), entity.m_9236_().m_8055_(entity.m_20183_()));
            BlockPos finalBlockpos = blockpos;
            portalBlocks.forEach((blockPos, b) -> {
                if (b.booleanValue()) {
                    TwilightForestMod.LOGGER.debug("Caching {}", blockPos);
                    destinationCoordinateCache.get(destDim.m_46472_().m_135782_()).put(new ColumnPos(blockPos.m_123341_(), blockPos.m_123343_()), new PortalPosition(finalBlockpos, destDim.m_46467_()));
                }
            });
            destDim.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)new BlockPos(columnPos.f_140723_(), blockpos.m_123342_(), columnPos.f_140724_()));
        }
        BlockPos[] portalBorder = TFTeleporter.getBoundaryPositions(destDim, blockpos).toArray(new BlockPos[0]);
        BlockPos borderPos = portalBorder[0];
        double portalX = (double)borderPos.m_123341_() + 0.5;
        double portalY = (double)borderPos.m_123342_() + 1.0;
        double portalZ = (double)borderPos.m_123343_() + 0.5;
        return TFTeleporter.makePortalInfo(entity, portalX, portalY, portalZ);
    }

    @Nullable
    private static BlockPos getPortalPosition(ServerLevel destDim, BlockPos pos) {
        int i = 200;
        double d0 = Double.MAX_VALUE;
        BlockPos result = null;
        for (int i1 = -i; i1 <= i; ++i1) {
            for (int j1 = -i; j1 <= i; ++j1) {
                if (!destDim.m_6857_().m_61937_(pos.m_7918_(i1, 0, j1))) continue;
                ChunkPos chunkPos = new ChunkPos(pos.m_7918_(i1, 0, j1));
                LevelChunk chunk = destDim.m_7726_().m_7131_(chunkPos.f_45578_, chunkPos.f_45579_);
                if (chunk == null || chunk.m_287138_() == FullChunkStatus.INACCESSIBLE) continue;
                BlockPos blockpos1 = pos.m_7918_(i1, TFTeleporter.getScanHeight(destDim, pos) - pos.m_123342_(), j1);
                while (blockpos1.m_123342_() >= 0) {
                    BlockPos blockpos2 = blockpos1.m_7495_();
                    if (!(d0 >= 0.0 && blockpos1.m_123331_((Vec3i)pos) >= d0 || !TFTeleporter.isPortal(chunk.m_8055_(blockpos1)))) {
                        blockpos2 = blockpos1.m_7495_();
                        while (TFTeleporter.isPortal(chunk.m_8055_(blockpos2))) {
                            blockpos1 = blockpos2;
                            blockpos2 = blockpos2.m_7495_();
                        }
                        float d1 = (float)blockpos1.m_123331_((Vec3i)pos);
                        if (d0 < 0.0 || (double)d1 < d0) {
                            d0 = d1;
                            result = blockpos1;
                            i = Mth.m_14167_((float)Mth.m_14116_((float)d1));
                        }
                    }
                    blockpos1 = blockpos2;
                }
            }
        }
        return result;
    }

    private static int getScanHeight(ServerLevel world, BlockPos pos) {
        return TFTeleporter.getScanHeight(world, pos.m_123341_(), pos.m_123343_());
    }

    private static int getScanHeight(ServerLevel world, int x, int z) {
        int worldHeight = world.m_151558_() - 1;
        int chunkHeight = world.m_6325_(x >> 4, z >> 4).m_62098_() + 15;
        return Math.min(worldHeight, chunkHeight);
    }

    private static boolean isPortal(BlockState state) {
        return state.m_60734_() == TFBlocks.TWILIGHT_PORTAL.get();
    }

    private static Set<BlockPos> getBoundaryPositions(ServerLevel world, BlockPos start) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        checked.add(start);
        TFTeleporter.checkAdjacent(world, start, checked, result);
        return result;
    }

    private static void checkAdjacent(ServerLevel world, BlockPos pos, Set<BlockPos> checked, Set<BlockPos> result) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.m_121945_(facing);
            if (!checked.add(offset)) continue;
            if (TFTeleporter.isPortalAt(world, offset)) {
                TFTeleporter.checkAdjacent(world, offset, checked, result);
                continue;
            }
            result.add(offset);
        }
    }

    private static boolean isPortalAt(ServerLevel world, BlockPos pos) {
        return TFTeleporter.isPortal(world.m_8055_(pos));
    }

    private static PortalInfo moveToSafeCoords(ServerLevel world, Entity entity, BlockPos pos) {
        boolean checkProgression = LandmarkUtil.isProgressionEnforced((Level)world);
        if (TFTeleporter.isSafeAround((Level)world, pos, entity, checkProgression)) {
            TwilightForestMod.LOGGER.debug("Portal destination looks safe!");
            return TFTeleporter.makePortalInfo(entity, Vec3.m_82512_((Vec3i)pos));
        }
        TwilightForestMod.LOGGER.debug("Portal destination looks unsafe, rerouting!");
        BlockPos safeCoords = TFTeleporter.findSafeCoords(world, 200, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.debug("Safely rerouted!");
            return TFTeleporter.makePortalInfo(entity, safeCoords.m_123341_(), entity.m_20186_(), safeCoords.m_123343_());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot first try, trying again with longer range.");
        safeCoords = TFTeleporter.findSafeCoords(world, 400, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to long range portal. Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(entity, safeCoords.m_123341_(), entity.m_20186_(), safeCoords.m_123343_());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot second try, trying to move slightly towards the center between key biomes.");
        safeCoords = TFTeleporter.findSafeCoords(world, 400, TFTeleporter.moveTowardsCenter(pos, 0.5f), entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to slightly centered portal. Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(entity, safeCoords.m_123341_(), entity.m_20186_(), safeCoords.m_123343_());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot third try, trying to move further towards the center between key biomes.");
        safeCoords = TFTeleporter.findSafeCoords(world, 400, TFTeleporter.moveTowardsCenter(pos, 0.9f), entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to very centered portal. Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(entity, safeCoords.m_123341_(), entity.m_20186_(), safeCoords.m_123343_());
        }
        TwilightForestMod.LOGGER.warn("Still did not find a safe portal spot.");
        return TFTeleporter.makePortalInfo(entity, Vec3.m_82512_((Vec3i)pos));
    }

    private static BlockPos moveTowardsCenter(BlockPos pos, float lerp) {
        ColumnPos centerPos = MagicMapItem.getMagicMapCenter(pos.m_123341_(), pos.m_123343_());
        float vx = centerPos.f_140723_() - pos.m_123341_();
        float vz = centerPos.f_140724_() - pos.m_123343_();
        float nx = (float)pos.m_123341_() + vx * lerp;
        float nz = (float)pos.m_123343_() + vz * lerp;
        return BlockPos.m_274561_((double)nx, (double)pos.m_123342_(), (double)nz);
    }

    public static boolean isSafeAround(Level world, BlockPos pos, Entity entity, boolean checkProgression) {
        if (!TFTeleporter.isSafe(world, pos, entity, checkProgression)) {
            return false;
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (TFTeleporter.isSafe(world, pos.m_5484_(facing, 16), entity, checkProgression)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafe(Level world, BlockPos pos, Entity entity, boolean checkProgression) {
        return !world.m_46472_().equals(TFGenerationSettings.DIMENSION_KEY) || TFTeleporter.checkPos(world, pos) && (!checkProgression || TFTeleporter.checkBiome(world, pos, entity)) && TFTeleporter.checkStructure(world, pos);
    }

    private static boolean checkPos(Level world, BlockPos pos) {
        return world.m_6857_().m_61937_(pos);
    }

    private static boolean checkStructure(Level world, BlockPos pos) {
        boolean outsideLandmarkRange;
        boolean bl = outsideLandmarkRange = !LegacyLandmarkPlacements.blockNearLandmarkCenter(pos.m_123341_(), pos.m_123343_(), 5);
        if (!outsideLandmarkRange) {
            return false;
        }
        Optional<StructureStart> possibleNearLandmark = LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)world, SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
        return possibleNearLandmark.isEmpty() || possibleNearLandmark.get().m_73601_().m_71051_((Vec3i)pos);
    }

    private static boolean checkBiome(Level world, BlockPos pos, Entity entity) {
        return TFGenerationSettings.isBiomeSafeFor((Biome)world.m_204166_(pos).m_203334_(), entity);
    }

    @Nullable
    private static BlockPos findSafeCoords(ServerLevel world, int range, BlockPos pos, Entity entity, boolean checkProgression) {
        int attempts = range / 8;
        for (int x = 0; x < attempts; ++x) {
            for (int z = 0; z < attempts; ++z) {
                BlockPos dPos = new BlockPos(pos.m_123341_() + x * attempts - range / 2, 100, pos.m_123343_() + z * attempts - range / 2);
                if (!TFTeleporter.isSafeAround((Level)world, dPos, entity, checkProgression)) continue;
                return dPos;
            }
        }
        return null;
    }

    private void makePortal(Entity entity, ServerLevel world, Vec3 pos) {
        ServerLevel serverLevel;
        Level level = entity.m_9236_();
        ServerLevel src = level instanceof ServerLevel ? (serverLevel = (ServerLevel)level) : null;
        TFTeleporter.loadSurroundingArea(world, pos);
        BlockPos spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isPortalAt(world, blockPos));
        String name = entity.m_7755_().getString();
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found existing portal for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cacheNewPortalCoords(src, spot, entity.m_20183_());
            return;
        }
        spot = TFTeleporter.findPortalCoords(world, pos, blockpos -> TFTeleporter.isIdealForPortal(world, blockpos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found ideal portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cacheNewPortalCoords(src, this.makePortalAt((Level)world, spot), entity.m_20183_());
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not find ideal portal spot, shooting for okay one for {}", (Object)name);
        spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isOkayForPortal(world, blockPos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found okay portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cacheNewPortalCoords(src, this.makePortalAt((Level)world, spot), entity.m_20183_());
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not even find an okay portal spot, just making a random one for {}", (Object)name);
        double yFactor = TFTeleporter.getYFactor(world);
        TFTeleporter.cacheNewPortalCoords(src, this.makePortalAt((Level)world, BlockPos.m_274561_((double)entity.m_20185_(), (double)(entity.m_20186_() * yFactor - 1.0), (double)entity.m_20189_())), entity.m_20183_());
    }

    private static void loadSurroundingArea(ServerLevel world, Vec3 pos) {
        int x = Mth.m_14107_((double)pos.f_82479_) >> 4;
        int z = Mth.m_14107_((double)pos.f_82480_) >> 4;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                world.m_6325_(x + dx, z + dz);
            }
        }
    }

    @Nullable
    private static BlockPos findPortalCoords(ServerLevel world, Vec3 loc, Predicate<BlockPos> predicate) {
        double yFactor = TFTeleporter.getYFactor(world);
        int entityX = Mth.m_14107_((double)loc.f_82479_);
        int entityZ = Mth.m_14107_((double)loc.f_82481_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        double spotWeight = -1.0;
        BlockPos spot = null;
        int range = 16;
        for (int rx = entityX - range; rx <= entityX + range; ++rx) {
            double xWeight = (double)rx + 0.5 - loc.f_82479_;
            for (int rz = entityZ - range; rz <= entityZ + range; ++rz) {
                double zWeight = (double)rz + 0.5 - loc.f_82481_;
                for (int ry = TFTeleporter.getScanHeight(world, rx, rz); ry >= world.m_141937_(); --ry) {
                    if (!world.m_46859_((BlockPos)pos.m_122178_(rx, ry, rz))) continue;
                    while (ry > world.m_141937_() && world.m_46859_((BlockPos)pos.m_122178_(rx, ry - 1, rz))) {
                        --ry;
                    }
                    double yWeight = (double)ry + 0.5 - loc.f_82480_ * yFactor;
                    double rPosWeight = xWeight * xWeight + yWeight * yWeight + zWeight * zWeight;
                    if (!(spotWeight < 0.0) && !(rPosWeight < spotWeight) || !predicate.test((BlockPos)pos)) continue;
                    spotWeight = rPosWeight;
                    spot = pos.m_7949_();
                }
            }
        }
        return spot;
    }

    private static double getYFactor(ServerLevel world) {
        return world.m_46472_().m_135782_().equals((Object)Level.f_46428_.m_135782_()) ? 2.0 : 0.5;
    }

    private static void cacheNewPortalCoords(@Nullable ServerLevel srcDim, BlockPos pos, BlockPos srcPos) {
        if (srcDim == null) {
            return;
        }
        BlockPos exitPos = TFTeleporter.getPortalPosition(srcDim, srcPos);
        if (exitPos == null) {
            return;
        }
        TwilightForestMod.LOGGER.debug("Caching Dest Portal Blocks to {}", (Object)exitPos);
        destinationCoordinateCache.putIfAbsent(srcDim.m_46472_().m_135782_(), Maps.newHashMapWithExpectedSize((int)4096));
        destinationCoordinateCache.get(srcDim.m_46472_().m_135782_()).put(new ColumnPos(pos.m_123341_(), pos.m_123343_()), new PortalPosition(exitPos, srcDim.m_46467_()));
        destinationCoordinateCache.get(srcDim.m_46472_().m_135782_()).put(new ColumnPos(pos.m_122019_().m_123341_(), pos.m_122019_().m_123343_()), new PortalPosition(exitPos, srcDim.m_46467_()));
        destinationCoordinateCache.get(srcDim.m_46472_().m_135782_()).put(new ColumnPos(pos.m_122029_().m_123341_(), pos.m_122029_().m_123343_()), new PortalPosition(exitPos, srcDim.m_46467_()));
        destinationCoordinateCache.get(srcDim.m_46472_().m_135782_()).put(new ColumnPos(pos.m_122019_().m_122029_().m_123341_(), pos.m_122019_().m_122029_().m_123343_()), new PortalPosition(exitPos, srcDim.m_46467_()));
    }

    private static boolean isIdealForPortal(ServerLevel world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    BlockPos tPos = pos.m_7918_(potentialX - 1, potentialY, potentialZ - 1);
                    BlockState state = world.m_8055_(tPos);
                    if ((potentialY != 0 || state.m_204336_(BlockTags.f_144274_)) && (potentialY < 1 || state.m_247087_())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected BlockPos makePortalAt(Level world, BlockPos pos) {
        BlockState grass = Blocks.f_50440_.m_49966_();
        world.m_46597_(pos.m_122024_().m_122012_(), grass);
        world.m_46597_(pos.m_122012_(), grass);
        world.m_46597_(pos.m_122029_().m_122012_(), grass);
        world.m_46597_(pos.m_122030_(2).m_122012_(), grass);
        world.m_46597_(pos.m_122024_(), grass);
        world.m_46597_(pos.m_122030_(2), grass);
        world.m_46597_(pos.m_122024_().m_122019_(), grass);
        world.m_46597_(pos.m_122030_(2).m_122019_(), grass);
        world.m_46597_(pos.m_122024_().m_122020_(2), grass);
        world.m_46597_(pos.m_122020_(2), grass);
        world.m_46597_(pos.m_122029_().m_122020_(2), grass);
        world.m_46597_(pos.m_122030_(2).m_122020_(2), grass);
        BlockState dirt = Blocks.f_50493_.m_49966_();
        world.m_46597_(pos.m_7495_(), dirt);
        world.m_46597_(pos.m_122029_().m_7495_(), dirt);
        world.m_46597_(pos.m_122019_().m_7495_(), dirt);
        world.m_46597_(pos.m_122029_().m_122019_().m_7495_(), dirt);
        BlockState portal = (BlockState)((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).m_49966_().m_61124_((Property)TFPortalBlock.DISALLOW_RETURN, (Comparable)Boolean.valueOf(locked || (Boolean)TFConfig.COMMON_CONFIG.shouldReturnPortalBeUsable.get() == false));
        world.m_7731_(pos, portal, 2);
        world.m_7731_(pos.m_122029_(), portal, 2);
        world.m_7731_(pos.m_122019_(), portal, 2);
        world.m_7731_(pos.m_122029_().m_122019_(), portal, 2);
        for (int dx = -1; dx <= 2; ++dx) {
            for (int dz = -1; dz <= 2; ++dz) {
                for (int dy = 1; dy <= 5; ++dy) {
                    world.m_7471_(pos.m_7918_(dx, dy, dz), false);
                }
            }
        }
        world.m_7731_(pos.m_122024_().m_122012_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122012_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122029_().m_122012_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122030_(2).m_122012_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122024_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122030_(2).m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122024_().m_122019_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122030_(2).m_122019_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122024_().m_122020_(2).m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122020_(2).m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122029_().m_122020_(2).m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_122030_(2).m_122020_(2).m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        return pos;
    }

    private static BlockState randNatureBlock(RandomSource random) {
        return ((Block)ForgeRegistries.BLOCKS.tags().getTag(BlockTagGenerator.GENERATED_PORTAL_DECO).getRandomElement(random).get()).m_49966_();
    }

    private static boolean isOkayForPortal(ServerLevel world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    BlockPos tPos = pos.m_7918_(potentialX - 1, potentialY, potentialZ - 1);
                    BlockState state = world.m_8055_(tPos);
                    if ((potentialY != 0 || state.m_280296_() || state.m_278721_()) && (potentialY < 1 || state.m_247087_())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static PortalInfo makePortalInfo(Entity entity, double x, double y, double z) {
        return TFTeleporter.makePortalInfo(entity, new Vec3(x, y, z));
    }

    private static PortalInfo makePortalInfo(Entity entity, Vec3 pos) {
        return new PortalInfo(pos, Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        entity.f_19789_ = 0.0f;
        return repositionEntity.apply(false);
    }

    static class PortalPosition {
        public final BlockPos pos;
        long lastUpdateTime;

        PortalPosition(BlockPos pos, long time) {
            this.pos = pos;
            this.lastUpdateTime = time;
        }
    }
}

