/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.element.render.over;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.element.render.MinimapElementReader;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.element.render.MinimapElementRendererHandler;
import xaero.common.minimap.render.MinimapRendererHelper;

public class MinimapElementOverMapRendererHandler
extends MinimapElementRendererHandler {
    private int halfViewW;
    private int halfViewH;
    private int specW;
    private int specH;
    private boolean circle;
    private float optionalScale;
    private final double[] partialTranslate;

    protected MinimapElementOverMapRendererHandler(List<MinimapElementRenderer<?, ?>> renderers, double[] partialTranslate) {
        super(renderers, 1);
        this.partialTranslate = partialTranslate;
    }

    public void render(GuiGraphics guiGraphics, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, double ps, double pc, double zoom, boolean cave, float partialTicks, RenderTarget framebuffer, IXaeroMinimap modMain, MinimapRendererHelper helper, MultiBufferSource.BufferSource renderTypeBuffers, Font font, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers, int specW, int specH, int halfViewW, int halfViewH, boolean circle, float minimapScale) {
        this.specW = specW;
        this.specH = specH;
        this.halfViewW = halfViewW;
        this.halfViewH = halfViewH;
        this.circle = circle;
        this.optionalScale = minimapScale;
        super.render(guiGraphics, renderEntity, player, renderX, renderY, renderZ, ps, pc, zoom, cave, partialTicks, framebuffer, modMain, helper, renderTypeBuffers, font, multiTextureRenderTypeRenderers);
    }

    @Override
    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(RR renderer, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, Font font, RenderTarget framebuffer, MinimapRendererHelper helper, Entity renderEntity, Player player, double renderX, double renderY, double renderZ, double ps, double pc, double zoom, boolean cave, float partialTicks, int elementIndex, double optionalDepth, E element, MinimapElementReader<E, RRC> elementReader, RRC context) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        double offx = elementReader.getRenderX(element, context, partialTicks) - renderX;
        double offy = elementReader.getRenderZ(element, context, partialTicks) - renderZ;
        matrixStack.m_85836_();
        boolean outOfBounds = MinimapElementOverMapRendererHandler.translatePosition(matrixStack, this.specW, this.specH, this.halfViewW, this.halfViewH, ps, pc, offx, offy, zoom, this.circle, this.partialTranslate);
        boolean result = renderer.renderElement(this.location, false, outOfBounds, guiGraphics, renderTypeBuffers, font, framebuffer, helper, renderEntity, player, renderX, renderY, renderZ, elementIndex, optionalDepth, this.optionalScale, element, this.partialTranslate[0], this.partialTranslate[1], cave, partialTicks);
        matrixStack.m_85849_();
        return result;
    }

    @Override
    protected void beforeRender(PoseStack matrixStack) {
    }

    @Override
    protected void afterRender(PoseStack matrixStack) {
    }

    @Override
    protected int getIndexLimit() {
        return 9800;
    }

    public static boolean translatePosition(PoseStack matrixStack, int specW, int specH, int halfViewW, int halfViewH, double ps, double pc, double offx, double offy, double zoom, boolean circle, double[] partialTranslate) {
        double X;
        boolean outOfBounds = false;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (!circle) {
            if (borderedX > (double)specW) {
                borderedX = specW;
                borderedY = Y * (double)specW / X;
                outOfBounds = true;
            } else if (borderedX < (double)(-specW)) {
                borderedX = -specW;
                borderedY = -Y * (double)specW / X;
                outOfBounds = true;
            }
            if (borderedY > (double)specH) {
                borderedY = specH;
                borderedX = X * (double)specH / Y;
                outOfBounds = true;
            } else if (borderedY < (double)(-specH)) {
                borderedY = -specH;
                borderedX = -X * (double)specH / Y;
                outOfBounds = true;
            }
            if (!outOfBounds && (borderedX > (double)halfViewW || borderedX < (double)(-halfViewW) || borderedY > (double)halfViewH || borderedY < (double)(-halfViewH))) {
                outOfBounds = true;
            }
        } else {
            double distSquared = borderedX * borderedX + borderedY * borderedY;
            double maxDistSquared = specW * specW;
            if (distSquared > maxDistSquared) {
                double scaleDown = Math.sqrt(maxDistSquared / distSquared);
                borderedX *= scaleDown;
                borderedY *= scaleDown;
                outOfBounds = true;
            }
            if (!outOfBounds && distSquared > (double)(halfViewW * halfViewW)) {
                outOfBounds = true;
            }
        }
        long roundedX = Math.round(borderedX);
        long roundedY = Math.round(borderedY);
        partialTranslate[0] = borderedX - (double)roundedX;
        partialTranslate[1] = borderedY - (double)roundedY;
        matrixStack.m_252880_((float)roundedX, (float)roundedY, 0.0f);
        return outOfBounds;
    }

    public static final class Builder
    extends MinimapElementRendererHandler.Builder {
        @Override
        public MinimapElementOverMapRendererHandler build() {
            return (MinimapElementOverMapRendererHandler)super.build();
        }

        @Override
        protected MinimapElementOverMapRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> renderers) {
            return new MinimapElementOverMapRendererHandler(renderers, new double[2]);
        }

        @Override
        protected Builder setDefault() {
            super.setDefault();
            return this;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

