/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;
import twilightforest.init.TFBlockEntities;

public abstract class AbstractSkullCandleBlock
extends AbstractLightableBlock {
    private final SkullBlock.Type type;

    public AbstractSkullCandleBlock(SkullBlock.Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
    }

    public SkullBlock.Type getType() {
        return this.type;
    }

    public int getLightEmission(BlockState state, BlockGetter getter, BlockPos pos) {
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            switch ((AbstractLightableBlock.Lighting)((Object)state.m_61143_((Property)LIGHTING))) {
                case NONE: {
                    return 0;
                }
                case NORMAL: {
                    return 3 * sc.getCandleAmount();
                }
                case OMINOUS: {
                    return 2 * sc.getCandleAmount();
                }
            }
        }
        return 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SkullCandleBlockEntity(pos, state, 0, 0);
    }

    public static Block candleColorToCandle(CandleColors color) {
        if (color != CandleColors.PLAIN) {
            return Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(color.m_7912_() + "_candle")));
        }
        return Blocks.f_152482_;
    }

    public static CandleColors candleToCandleColor(Item candle) {
        if (candle != Blocks.f_152482_.m_5456_()) {
            return CandleColors.valueOf(ForgeRegistries.ITEMS.getKey((Object)candle).m_135815_().replace("_candle", "").replace("\"", "").toUpperCase(Locale.ROOT));
        }
        return CandleColors.PLAIN;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockentity;
            if (stack.m_41782_() && stack.m_41783_() != null) {
                CompoundTag tag = stack.m_41737_("BlockEntityTag");
                if (tag != null) {
                    if (tag.m_128441_("CandleAmount")) {
                        sc.setCandleAmount(tag.m_128451_("CandleAmount"));
                    }
                    if (tag.m_128441_("CandleColor")) {
                        sc.setCandleColor(tag.m_128451_("CandleColor"));
                    }
                }
                if (this.type == SkullBlock.Types.PLAYER) {
                    GameProfile gameprofile = null;
                    CompoundTag compoundtag = stack.m_41783_();
                    if (compoundtag.m_128425_("SkullOwner", 10)) {
                        gameprofile = NbtUtils.m_129228_((CompoundTag)compoundtag.m_128469_("SkullOwner"));
                    } else if (compoundtag.m_128425_("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundtag.m_128461_("SkullOwner"))) {
                        gameprofile = new GameProfile(null, compoundtag.m_128461_("SkullOwner"));
                    }
                    sc.m_59769_(gameprofile);
                }
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity;
        List drops = super.m_49635_(state, builder);
        Optional<ItemStack> skullStack = drops.stream().filter(item -> item.m_204117_(Tags.Items.HEADS) && !item.m_150930_(this.m_5456_())).findFirst();
        if (skullStack.isPresent() && (blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_)) instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            if (!((ItemStack)builder.m_287261_(LootContextParams.f_81463_)).m_41619_() && ((ItemStack)builder.m_287261_(LootContextParams.f_81463_)).getEnchantmentLevel(Enchantments.f_44985_) > 0) {
                ItemStack newStack = new ItemStack((ItemLike)this);
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("CandleColor", sc.getCandleColor());
                tag.m_128405_("CandleAmount", sc.getCandleAmount());
                newStack.m_41700_("BlockEntityTag", (Tag)tag);
                if (sc.m_59779_() != null) {
                    newStack.m_41784_().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)sc.m_59779_()));
                }
                drops.remove(skullStack.get());
                drops.add(newStack);
            } else {
                drops.add(new ItemStack((ItemLike)AbstractSkullCandleBlock.candleColorToCandle(CandleColors.colorFromInt(sc.getCandleColor())), sc.getCandleAmount()));
            }
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult result, BlockGetter getter, BlockPos pos, Player player) {
        ItemStack newStack = new ItemStack((ItemLike)this);
        CompoundTag tag = new CompoundTag();
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            if (sc.m_59779_() != null) {
                newStack.m_41784_().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)sc.m_59779_()));
            }
            tag.m_128405_("CandleColor", sc.getCandleColor());
            tag.m_128405_("CandleAmount", sc.getCandleAmount());
            newStack.m_41700_("BlockEntityTag", (Tag)tag);
        }
        return newStack;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            if (player.m_21120_(hand).m_204117_(ItemTags.f_144319_) && player.m_21120_(hand).m_150930_(AbstractSkullCandleBlock.candleColorToCandle(CandleColors.colorFromInt(sc.getCandleColor())).m_5456_()) && !player.m_6144_() && sc.getCandleAmount() < 4) {
                sc.incrementCandleAmount();
                level.m_5594_(null, pos, SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(hand).m_41774_(1);
                }
                level.m_5518_().m_7174_(pos);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (state.m_61143_((Property)LIGHTING) != AbstractLightableBlock.Lighting.NONE) {
            this.getParticleOffsets(state, (LevelAccessor)level, pos).forEach(offset -> AbstractSkullCandleBlock.addParticlesAndSound(level, offset.m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), rand, state.m_61143_((Property)LIGHTING) == AbstractLightableBlock.Lighting.OMINOUS));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return AbstractSkullCandleBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.SKULL_CANDLE.get()), SkullCandleBlockEntity::tick);
    }

    public static enum CandleColors implements StringRepresentable
    {
        PLAIN(0),
        WHITE(1),
        LIGHT_GRAY(2),
        GRAY(3),
        BLACK(4),
        RED(5),
        ORANGE(6),
        YELLOW(7),
        GREEN(8),
        LIME(9),
        BLUE(10),
        CYAN(11),
        LIGHT_BLUE(12),
        PURPLE(13),
        MAGENTA(14),
        PINK(15),
        BROWN(16);

        private final int value;
        private static final Map<Integer, CandleColors> map;

        private CandleColors(int value) {
            this.value = value;
        }

        public static CandleColors colorFromInt(int value) {
            return map.get(value);
        }

        public int getValue() {
            return this.value;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            map = new HashMap<Integer, CandleColors>();
            for (CandleColors color : CandleColors.values()) {
                map.put(color.value, color);
            }
        }
    }
}

