/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;

public class WallSkullCandleBlock
extends AbstractSkullCandleBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)));
    private static final Map<Direction, VoxelShape> PIGLIN_AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)3.0, (double)4.0, (double)8.0, (double)13.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)3.0, (double)4.0, (double)0.0, (double)13.0, (double)12.0, (double)8.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)4.0, (double)3.0, (double)8.0, (double)12.0, (double)13.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)8.0, (double)4.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0)));
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.m_137537_(() -> {
        Int2ObjectOpenHashMap var0 = new Int2ObjectOpenHashMap();
        var0.defaultReturnValue((Object)ImmutableList.of());
        var0.put(1, (Object)ImmutableList.of((Object)new Vec3(0.5, 1.25, 0.5)));
        var0.put(2, (Object)ImmutableList.of((Object)new Vec3(0.375, 1.19, 0.5), (Object)new Vec3(0.625, 1.25, 0.44)));
        var0.put(3, (Object)ImmutableList.of((Object)new Vec3(0.5, 1.063, 0.625), (Object)new Vec3(0.375, 1.19, 0.5), (Object)new Vec3(0.56, 1.25, 0.44)));
        var0.put(4, (Object)ImmutableList.of((Object)new Vec3(0.44, 1.063, 0.56), (Object)new Vec3(0.625, 1.19, 0.56), (Object)new Vec3(0.375, 1.19, 0.375), (Object)new Vec3(0.56, 1.25, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)var0);
    });

    public WallSkullCandleBlock(SkullBlock.Type type, BlockBehaviour.Properties properties) {
        super(type, properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.getType() == SkullBlock.Types.PIGLIN ? PIGLIN_AABBS.get(state.m_61143_((Property)FACING)) : AABBS.get(state.m_61143_((Property)FACING));
    }

    @Override
    protected Iterable<Vec3> getParticleOffsets(BlockState state, LevelAccessor accessor, BlockPos pos) {
        BlockEntity blockEntity = accessor.m_7702_(pos);
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            return (Iterable)PARTICLE_OFFSETS.get(sc.getCandleAmount());
        }
        return (Iterable)PARTICLE_OFFSETS.get(1);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction[] directions;
        BlockState state = this.m_49966_();
        Level getter = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        for (Direction dir : directions = ctx.m_6232_()) {
            if (!dir.m_122434_().m_122479_()) continue;
            Direction var10 = dir.m_122424_();
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)var10);
            if (getter.m_8055_(pos.m_121945_(dir)).m_60629_(ctx)) continue;
            return (BlockState)state.m_61124_((Property)LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE));
        }
        return null;
    }

    @Override
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (state.m_61143_((Property)LIGHTING) != AbstractLightableBlock.Lighting.NONE) {
            this.getParticleOffsets(state, (LevelAccessor)level, pos).forEach(offset -> WallSkullCandleBlock.addParticlesAndSound(level, offset.m_82520_((double)((float)pos.m_123341_() - (float)dir.m_122429_() * 0.25f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() - (float)dir.m_122431_() * 0.25f)), rand, state.m_61143_((Property)LIGHTING) == AbstractLightableBlock.Lighting.OMINOUS));
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }
}

