/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.dispenser;

import net.minecraft.core.BlockSource;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.TrophyBlock;
import twilightforest.dispenser.CrumbleDispenseBehavior;
import twilightforest.dispenser.DamageableStackDispenseBehavior;
import twilightforest.dispenser.FeatherFanDispenseBehavior;
import twilightforest.dispenser.IgniteLightableDispenseBehavior;
import twilightforest.dispenser.SkullCandleDispenseBehavior;
import twilightforest.dispenser.TransformationDispenseBehavior;
import twilightforest.entity.projectile.IceBomb;
import twilightforest.entity.projectile.MoonwormShot;
import twilightforest.entity.projectile.TwilightWandBolt;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFSounds;

public class TFDispenserBehaviors {
    public static void init() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)TFItems.MOONWORM_QUEEN.get()), (DispenseItemBehavior)new DamageableStackDispenseBehavior(){

            @Override
            protected Projectile getProjectileEntity(Level level, Position position, ItemStack stack) {
                return new MoonwormShot(level, position.m_7096_(), position.m_7098_(), position.m_7094_());
            }

            @Override
            protected int getDamageAmount() {
                return 2;
            }

            @Override
            protected SoundEvent getFiredSound() {
                return (SoundEvent)TFSounds.MOONWORM_SQUISH.get();
            }
        });
        OptionalDispenseItemBehavior idispenseitembehavior = new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                this.m_123573_(ArmorItem.m_40398_((BlockSource)source, (ItemStack)stack));
                return stack;
            }
        };
        DispenserBlock.m_52672_((ItemLike)((TrophyBlock)((Object)TFBlocks.NAGA_TROPHY.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((TrophyBlock)((Object)TFBlocks.LICH_TROPHY.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((TrophyBlock)((Object)TFBlocks.MINOSHROOM_TROPHY.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((TrophyBlock)((Object)TFBlocks.HYDRA_TROPHY.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((TrophyBlock)((Object)TFBlocks.KNIGHT_PHANTOM_TROPHY.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((TrophyBlock)((Object)TFBlocks.UR_GHAST_TROPHY.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((TrophyBlock)((Object)TFBlocks.ALPHA_YETI_TROPHY.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((TrophyBlock)((Object)TFBlocks.SNOW_QUEEN_TROPHY.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((TrophyBlock)((Object)TFBlocks.QUEST_RAM_TROPHY.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((AbstractSkullCandleBlock)((Object)TFBlocks.CREEPER_SKULL_CANDLE.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((AbstractSkullCandleBlock)((Object)TFBlocks.PLAYER_SKULL_CANDLE.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((AbstractSkullCandleBlock)((Object)TFBlocks.SKELETON_SKULL_CANDLE.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((AbstractSkullCandleBlock)((Object)TFBlocks.WITHER_SKELE_SKULL_CANDLE.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((AbstractSkullCandleBlock)((Object)TFBlocks.ZOMBIE_SKULL_CANDLE.get())).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((Block)TFBlocks.CICADA.get()).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((Block)TFBlocks.FIREFLY.get()).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((Block)TFBlocks.MOONWORM.get()).m_5456_(), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((Item)TFItems.PEACOCK_FEATHER_FAN.get()).m_5456_(), (DispenseItemBehavior)new FeatherFanDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)((Item)TFItems.CRUMBLE_HORN.get()).m_5456_(), (DispenseItemBehavior)new CrumbleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)((Item)TFItems.TRANSFORMATION_POWDER.get()).m_5456_(), (DispenseItemBehavior)new TransformationDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)TFItems.TWILIGHT_SCEPTER.get()), (DispenseItemBehavior)new DamageableStackDispenseBehavior(){

            @Override
            protected Projectile getProjectileEntity(Level level, Position position, ItemStack stack) {
                return new TwilightWandBolt(level, position.m_7096_(), position.m_7098_(), position.m_7094_());
            }

            @Override
            protected int getDamageAmount() {
                return 1;
            }

            @Override
            protected SoundEvent getFiredSound() {
                return (SoundEvent)TFSounds.SCEPTER_PEARL.get();
            }

            @Override
            protected float getProjectileInaccuracy() {
                return 6.0f;
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)TFItems.ICE_BOMB.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level level, Position pos, ItemStack stack) {
                return new IceBomb(level, pos);
            }
        });
        DispenseItemBehavior cachedFlintBehavior = (DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_42409_);
        DispenseItemBehavior cachedFireChargeBehavior = (DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_42613_);
        DispenserBlock.m_52672_((ItemLike)Items.f_42409_, (DispenseItemBehavior)new IgniteLightableDispenseBehavior(cachedFlintBehavior));
        DispenserBlock.m_52672_((ItemLike)Items.f_42613_, (DispenseItemBehavior)new IgniteLightableDispenseBehavior(cachedFireChargeBehavior));
        DispenserBlock.m_52672_((ItemLike)Items.f_151065_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151082_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151073_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151074_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151066_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151081_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151067_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151070_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151080_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151071_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151077_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151075_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151069_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151076_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151068_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151072_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
        DispenserBlock.m_52672_((ItemLike)Items.f_151078_, (DispenseItemBehavior)new SkullCandleDispenseBehavior());
    }
}

