/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.capabilities.CapabilityList;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.events.HostileMountEvents;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.ThrowPlayerPacket;

public class ThrowRiderGoal
extends MeleeAttackGoal {
    private int throwTimer;
    private int timeout;
    private int cooldown;

    public ThrowRiderGoal(PathfinderMob creature, double speedIn, boolean useLongMemory) {
        super(creature, speedIn, useLongMemory);
    }

    public boolean m_8036_() {
        return this.f_25540_.m_20197_().isEmpty() && this.f_25540_.m_5448_() != null && !this.f_25540_.m_5448_().m_6095_().m_204039_(Tags.EntityTypes.BOSSES) && this.f_25540_.m_5448_().getCapability(CapabilityList.YETI_THROWN).map(cap -> cap.getThrowCooldown() <= 0).orElse(true) != false && super.m_8036_();
    }

    public void m_8056_() {
        this.throwTimer = 10 + this.f_25540_.m_217043_().m_188503_(30);
        this.timeout = 80 + this.f_25540_.m_217043_().m_188503_(40);
        super.m_8056_();
    }

    public void m_8037_() {
        --this.timeout;
        if (!this.f_25540_.m_20197_().isEmpty()) {
            --this.throwTimer;
        } else {
            super.m_8037_();
        }
    }

    protected void m_6739_(LivingEntity victim, double p_190102_2_) {
        double d0 = this.m_6639_(victim);
        if (p_190102_2_ <= d0 && this.m_25565_() <= 0 && this.f_25540_.m_20197_().isEmpty() && this.cooldown-- == 0) {
            Entity v;
            this.cooldown = 3;
            this.m_25563_();
            this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
            if (this.f_25540_.m_20197_().isEmpty() && ((v = victim.m_20202_()) == null || !v.m_6095_().m_204039_(EntityTagGenerator.RIDES_OBSTRUCT_SNATCHING))) {
                victim.m_8127_();
                victim.m_7998_((Entity)this.f_25540_, true);
            }
        }
    }

    public void m_8041_() {
        if (!this.f_25540_.m_20197_().isEmpty()) {
            Entity rider = (Entity)this.f_25540_.m_20197_().get(0);
            HostileMountEvents.allowDismount = true;
            rider.m_8127_();
            HostileMountEvents.allowDismount = false;
            Vec3 throwVec = this.f_25540_.m_20154_().m_82490_(2.0);
            throwVec = new Vec3(throwVec.m_7096_(), 0.9, throwVec.m_7094_());
            rider.m_5997_(throwVec.m_7096_(), throwVec.m_7098_(), throwVec.m_7094_());
            if (rider instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)rider;
                entity.getCapability(CapabilityList.YETI_THROWN).ifPresent(cap -> {
                    if (entity instanceof Player) {
                        cap.setThrown(true, (LivingEntity)this.f_25540_);
                    }
                    cap.setThrowCooldown(200);
                });
            }
            if (rider instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)rider;
                ThrowPlayerPacket message = new ThrowPlayerPacket(throwVec.m_7096_(), throwVec.m_7098_(), throwVec.m_7094_());
                TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
            }
        }
        super.m_8041_();
    }

    public boolean m_8045_() {
        return this.throwTimer > 0 && !this.f_25540_.m_20197_().isEmpty() || this.timeout > 0 && super.m_8045_() && this.f_25540_.m_20197_().isEmpty();
    }
}

