/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import twilightforest.entity.passive.FlyingBird;
import twilightforest.init.TFSounds;
import twilightforest.init.custom.TinyBirdVariant;

public class TinyBird
extends FlyingBird {
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(TinyBird.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public TinyBird(EntityType<? extends TinyBird> type, Level level) {
        super(type, level);
        this.setBirdType(TinyBirdVariant.getVariantId(TinyBirdVariant.getRandomVariant(this.m_217043_())));
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 8.0f, 1.0, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 8.0f, 1.0, 1.25));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TYPE, (Object)TinyBirdVariant.getVariantId(TinyBirdVariant.getRandomVariant(this.m_217043_())));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return FlyingBird.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("BirdType", TinyBirdVariant.getVariantId(this.getBirdType()));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBirdType(compound.m_128461_("BirdType"));
    }

    public TinyBirdVariant getBirdType() {
        return TinyBirdVariant.getVariant((String)this.m_20088_().m_135370_(TYPE)).orElse((TinyBirdVariant)TinyBirdVariant.BLUE.get());
    }

    public void setBirdType(String type) {
        this.m_20088_().m_135381_(TYPE, (Object)type);
    }

    protected SoundEvent m_7515_() {
        return this.m_217043_().m_188503_(20) == 0 ? (SoundEvent)TFSounds.TINY_BIRD_SONG.get() : (SoundEvent)TFSounds.TINY_BIRD_CHIRP.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.TINY_BIRD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.TINY_BIRD_HURT.get();
    }

    public float m_20236_(Pose pose) {
        return this.m_20206_() * 0.7f;
    }

    @Override
    public boolean isSpooked() {
        if (this.m_21188_() != null) {
            return true;
        }
        Player closestPlayer = this.m_9236_().m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0, true);
        return closestPlayer != null && !SEEDS.test(closestPlayer.m_21205_()) && !SEEDS.test(closestPlayer.m_21206_());
    }
}

