/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.thrown.YetiThrowCapability;
import twilightforest.entity.IHostileMount;
import twilightforest.init.TFDamageTypes;

@Mod.EventBusSubscriber(modid="twilightforest")
public class HostileMountEvents {
    public static volatile boolean allowDismount = false;

    @SubscribeEvent
    public static void entityHurts(LivingAttackEvent event) {
        LivingEntity living = event.getEntity();
        DamageSource damageSource = event.getSource();
        if (living instanceof Player && HostileMountEvents.isRidingUnfriendly(living) && damageSource.m_276093_(DamageTypes.f_268612_)) {
            event.setCanceled(true);
        }
        if (damageSource.m_276093_(DamageTypes.f_268671_) && living.getCapability(CapabilityList.YETI_THROWN).map(YetiThrowCapability::getThrown).orElse(false).booleanValue()) {
            float amount = event.getAmount();
            event.setCanceled(true);
            living.m_6469_(TFDamageTypes.getEntityDamageSource(living.m_9236_(), TFDamageTypes.YEETED, (Entity)((YetiThrowCapability)living.getCapability(CapabilityList.YETI_THROWN).resolve().get()).getThrower(), new EntityType[0]), amount);
        }
    }

    @SubscribeEvent
    public static void entityTeleports(EntityTeleportEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && HostileMountEvents.isRidingUnfriendly(living = (LivingEntity)entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventMountDismount(EntityMountEvent event) {
        Player player;
        Entity entity;
        if (!event.getEntityBeingMounted().m_9236_().m_5776_() && !event.isMounting() && event.getEntityBeingMounted().m_6084_() && (entity = event.getEntityMounting()) instanceof Player && (player = (Player)entity).m_6084_() && HostileMountEvents.isRidingUnfriendly((LivingEntity)player) && !allowDismount && !player.m_150110_().f_35934_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof IHostileMount) {
            event.getEntity().m_20197_().forEach(e -> e.m_20260_(false));
        }
    }

    public static boolean isRidingUnfriendly(LivingEntity entity) {
        return entity.m_20159_() && entity.m_20202_() instanceof IHostileMount;
    }
}

